function rbf = RBFbestresult_D(x,y,id)
kfold = max(id);
alpha_iter =  [0.01,0.05,0.1,0.2,0.5,0.6,0.7,0.8,1,2,3,4,5,10,20,30,40,100];
mse_test = 10^10;
mse_train = 10^10;
n1 = length(alpha_iter);
for i = 1:length(alpha_iter)
     alpha = alpha_iter(i);
     kernel_train = cell(kfold,1);
     kernel_test = cell(kfold,1);
     y_train = cell(kfold,1);
     y_test = cell(kfold,1);
     for q = 1:kfold
         id_train = find(id ~= q);
         id_test = find(id == q);
         kernel_train{q} = gramRBF(x(id_train,:),x(id_train,:),alpha);
         kernel_test{q} = gramRBF(x(id_test,:),x(id_train,:),alpha);
         y_train{q} = y(id_train);
         y_test{q} = y(id_test);
     end
      [mse_current_test,mse_current_train,lambda_current] = give_me_best_mse(kernel_train,kernel_test,y_train,y_test);
      if mse_current_test < mse_test
         mse_test = mse_current_test;
         mse_train = mse_current_train;
         lambda = lambda_current;
         best_alpha = alpha_iter(i);
      end 
      %percent_complete = 100*i/n1;
      %fprintf('RBF: %.2f percent complete with best mse: %.5f \n',percent_complete,mse_test);
end
rbf = struct();
rbf.mse_test_kfold = mse_test;
rbf.mse_train_kfold = mse_train;
rbf.alpha = best_alpha;
rbf.lambda = lambda;
end

